program kloder3;

{$N+,E+}

uses  crt, printer, dos, graph, koovin8;

const strl=65;

type  str12 = string[12];
      str15 = string[15];
      infstr = string[strl];

var   x1,x2,x3,y1,y2,y3,xr1,xr3,yr3 : real;
      xf1,xf2,xf3,yf1,yf2,yf3,xg1,yg1,xg2,yg2,xg3,yg3,xrg3,yrg3 : real;
      t,dt,tstop,tstart,dt2,dt6,dt8 : real;
      rmin1,rmin2,rmin3,rr12,rrg12,rm1,rm2,rm3 : real;
      vx1,vx2,vx3,vy1,vy2,vy3,ax1,ax2,ax3,ay1,ay2,ay3 : real;
      dx1,dx2,dx3,dy1,dy2,dy3,dvx1,dvx2,dvx3,dvy1,dvy2,dvy3 : real;
      vxf1,vxf2,vxf3,vyf1,vyf2,vyf3 : real;
      m1,m2,m3,G,Gm1,Gm2,Gm3,K12 : real;
      fksrel,fpoin,fgraf,fmrk1,fmrk2,fmrk3,fprint,pfil : byte;
      c1,c2,c3,baggr : byte;
      xmin,xmax,ymin,ymax,fyx : real;
      GraphDriver, Graphmode, ErrCode : integer;
      svar : char;
      i,sinke : word;
      talfelt,taldec : shortint;
      inf,NDirFil,NDF : infstr;
      NFil : str15;
      srec : searchrec;


procedure start;

  var  i : byte;

begin

  G:=4*pi*pi;

  m1:=1; m2:=1; m3:=0;

  xf1:=-0.5; yf1:=0;
  xf2:=0.5; yf2:=0;
  xf3:=-0.7; yf3:=0;

  K12:=sqrt(G/(m1+m2)/(xf2-xf1));
  vxf1:=0; vyf1:=K12*m2;
  vxf2:=0; vyf2:=-K12*m1;
  vxf3:=0; vyf3:=-sqrt(G*m1/(xf1-xf3))+vyf1;

  xmin:=-1.5; xmax:=1.5;
  fyx:=0.75; ymin:=-(xmax-xmin)*fyx/2;
  xr1:=-0.5;

  fksrel:=0;  fgraf:=1; fprint:=0;
  fmrk1:=1; fmrk2:=1; fmrk3:=0;
  pfil:=1;

  tstart:=0;  tstop:=1000; dt:=0.001;

  rmin1:=50*dt; rmin2:=50*dt; rmin3:=10*dt;

  talfelt:=10; taldec:=3;

  sinke:=20;

  c1:=10; c2:=11; c3:=12;

  inf:='Basisdata';
  for i:=1 to strl-length(inf) do inf:=inf+' ';

  NDF:='kl3data'; NDirFil:=NDF+'\';
  NFil:='kl3.000';

  t:=0;
  x1:=0; y1:=0; x2:=0; y2:=0; x3:=0; y3:=0;
  vx1:=0; vy1:=0; vx2:=0; vy2:=0; vx3:=0; vy3:=0;
end;



procedure model(x1,y1,x2,y2,x3,y3 : real);

var  r12,r23,r31,cr12,cr23,cr31,dr12,dr23,dr31 : real;

begin

  cr12:=(x1-x2)*(x1-x2)+(y1-y2)*(y1-y2);
  cr23:=(x2-x3)*(x2-x3)+(y2-y3)*(y2-y3);
  cr31:=(x3-x1)*(x3-x1)+(y3-y1)*(y3-y1);

  r12:=sqrt(cr12);
  r23:=sqrt(cr23);
  r31:=sqrt(cr31);

  if r12<rmin1+rmin2 then cr12:=(rmin1+rmin2)*(rmin1+rmin2);
  if r23<rmin2+rmin3 then cr23:=(rmin2+rmin3)*(rmin2+rmin3);
  if r31<rmin3+rmin1 then cr31:=(rmin3+rmin1)*(rmin3+rmin1);

  dr12:=cr12*r12;
  dr23:=cr23*r23;
  dr31:=cr31*r31;

  ax1:=Gm2*(x2-x1)/dr12+Gm3*(x3-x1)/dr31;
  ay1:=Gm2*(y2-y1)/dr12+Gm3*(y3-y1)/dr31;
  ax2:=Gm3*(x3-x2)/dr23+Gm1*(x1-x2)/dr12;
  ay2:=Gm3*(y3-y2)/dr23+Gm1*(y1-y2)/dr12;
  ax3:=Gm1*(x1-x3)/dr31+Gm2*(x2-x3)/dr23;
  ay3:=Gm1*(y1-y3)/dr31+Gm2*(y2-y3)/dr23;

end;




procedure relativ(x1,y1,x2,y2,x3,y3:real; var xr3,yr3,rr12:real);
var prik1,prik2 : real;
begin
  rr12:=sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
  prik1:=(x3-x1)*(x2-x1)+(y3-y1)*(y2-y1);
  prik2:=(x3-x1)*(y1-y2)+(y3-y1)*(x2-x1);
  xr3:=xr1+prik1/rr12; yr3:=prik2/rr12;
end;



procedure tabel;
begin
  if fprint=0 then
  begin
    writeln('t = ',t:talfelt:taldec,'   x1 = ',x1:talfelt:taldec,
                                    '   y1 = ',y1:talfelt:taldec);
    writeln('t = ',t:talfelt:taldec,'   x2 = ',x2:talfelt:taldec,
                                    '   y2 = ',y2:talfelt:taldec);
    writeln('t = ',t:talfelt:taldec,'   x3 = ',x3:talfelt:taldec,
                                    '   y3 = ',y3:talfelt:taldec)
  end
  else
  begin
    writeln(lst,'t = ',t:talfelt:taldec,'   x1 = ',x1:talfelt:taldec,
                                        '   y1 = ',y1:talfelt:taldec);
    writeln(lst,'t = ',t:talfelt:taldec,'   x2 = ',x2:talfelt:taldec,
                                        '   y2 = ',y2:talfelt:taldec);
    writeln(lst,'t = ',t:talfelt:taldec,'   x3 = ',x3:talfelt:taldec,
                                        '   y3 = ',y3:talfelt:taldec);
  end;
end;



procedure grafini;
begin
  GraphDriver := Detect;
  InitGraph(GraphDriver,GraphMode,'');
  ErrCode := GraphResult;
  if ErrCode<>grOk then
  begin
    Writeln('Graphics error:', GraphErrorMsg(ErrCode));
    halt;
  end;
  SetBkColor(0);
  baggr:=GetBkColor;
  RestoreCrtMode;
end;


procedure plot(x,y,rmin,rm:real; c:byte);

begin
  setcolor(c);
  nymoveto(x-rm,y-rm); nylineto(x+rm,y+rm);
  nymoveto(x-rm,y+rm); nylineto(x+rm,y-rm);
  nymoveto(x-rmin,y); nylineto(x+rmin,y);
  nymoveto(x,y+rmin); nylineto(x,y-rmin);
end;


procedure ud;
begin
  if fgraf=1 then
    if fksrel=0 then
    begin
      if fmrk1=1 then
      begin plot(xg1,yg1,rmin1,rm1,c1); plot(x1,y1,rmin1,rm1,c1); end
      else nyputpixel(x1,y1,c1);
      if fmrk2=1 then
      begin plot(xg2,yg2,rmin2,rm2,c2); plot(x2,y2,rmin2,rm2,c2); end
      else nyputpixel(x2,y2,c2);
      if fmrk3=1 then
      begin plot(xg3,yg3,rmin3,rm3,c3); plot(x3,y3,rmin3,rm3,c3); end
      else nyputpixel(x3,y3,c3);
    end
    else
    begin
      relativ(xg1,yg1,xg2,yg2,xg3,yg3,xrg3,yrg3,rrg12);
      relativ(x1,y1,x2,y2,x3,y3,xr3,yr3,rr12);
      if fmrk1=1 then
      begin plot(xr1,0,rmin1,rm1,c1); plot(xr1,0,rmin1,rm1,c1); end
      else nyputpixel(xr1,0,c1);
      if fmrk2=1 then
      begin plot(xr1+rrg12,0,rmin2,rm2,c2);
            plot(xr1+rr12,0,rmin2,rm2,c2); end
      else nyputpixel(xr1+rr12,0,c2);
      if fmrk3=1 then
      begin plot(xrg3,yrg3,rmin3,rm3,c3); plot(xr3,yr3,rmin3,rm3,c3); end
      else nyputpixel(xr3,yr3,c3);
    end
  else
  begin
    model(x1,y1,x2,y2,x3,y3);
    tabel;
  end;
end;


procedure rk4b;

var  da1x1,da1x2,da1x3,da2x1,da2x2,da2x3,da3x1,da3x2,da3x3 : real;
     da1y1,da1y2,da1y3,da2y1,da2y2,da2y3,da3y1,da3y2,da3y3 : real;

begin

  model(x1,y1,x2,y2,x3,y3);

  da1x1:=ax1*dt; da1y1:=ay1*dt;
  da1x2:=ax2*dt; da1y2:=ay2*dt;
  da1x3:=ax3*dt; da1y3:=ay3*dt;

  model(x1+vx1*dt2+da1x1*dt8,y1+vy1*dt2+da1y1*dt8,x2+vx2*dt2+da1x2*dt8,
        y2+vy2*dt2+da1y2*dt8,x3+vx3*dt2+da1x3*dt8,y3+vy3*dt2+da1y3*dt8);

  da2x1:=ax1*dt; da2y1:=ay1*dt;
  da2x2:=ax2*dt; da2y2:=ay2*dt;
  da2x3:=ax3*dt; da2y3:=ay3*dt;

  model(x1+vx1*dt+da2x1*dt2,y1+vy1*dt+da2y1*dt2,x2+vx2*dt+da2x2*dt2,
        y2+vy2*dt+da2y2*dt2,x3+vx3*dt+da2x3*dt2,y3+vy3*dt+da2y3*dt2);

  da3x1:=ax1*dt; da3y1:=ay1*dt;
  da3x2:=ax2*dt; da3y2:=ay2*dt;
  da3x3:=ax3*dt; da3y3:=ay3*dt;

  dx1:=vx1*dt+(da1x1+2*da2x1)*dt6;
  dy1:=vy1*dt+(da1y1+2*da2y1)*dt6;
  dx2:=vx2*dt+(da1x2+2*da2x2)*dt6;
  dy2:=vy2*dt+(da1y2+2*da2y2)*dt6;
  dx3:=vx3*dt+(da1x3+2*da2x3)*dt6;
  dy3:=vy3*dt+(da1y3+2*da2y3)*dt6;

  dvx1:=(da1x1+4*da2x1+da3x1)/6;
  dvy1:=(da1y1+4*da2y1+da3y1)/6;
  dvx2:=(da1x2+4*da2x2+da3x2)/6;
  dvy2:=(da1y2+4*da2y2+da3y2)/6;
  dvx3:=(da1x3+4*da2x3+da3x3)/6;
  dvy3:=(da1y3+4*da2y3+da3y3)/6;

end;


procedure simulering;

var  talstreng : string;

begin

  Gm1:=G*m1; Gm2:=G*m2; Gm3:=G*m3;
  x1:=xf1; x2:=xf2; x3:=xf3; y1:=yf1; y2:=yf2; y3:=yf3;
  vx1:=vxf1; vx2:=vxf2; vx3:=vxf3; vy1:=vyf1; vy2:=vyf2; vy3:=vyf3;
  t:=tstart; dt2:=dt/2; dt6:=dt/6; dt8:=dt/8;

  clrscr;
  if fgraf=1 then
  begin
    rm1:=rmin1/sqrt(2); rm2:=rmin2/sqrt(2); rm3:=rmin3/sqrt(2);
    ymax:=ymin+(xmax-xmin)*fyx;
    ks(xmin,xmax,ymin,ymax,talfelt,taldec);
    setwritemode(XORput);

    if fksrel=0 then
    begin
      if fmrk1=1 then
      plot(x1,y1,rmin1,rm1,c1) else nyputpixel(x1,y1,c1);
      if fmrk2=1 then
      plot(x2,y2,rmin2,rm2,c2) else nyputpixel(x2,y2,c2);
      if fmrk3=1 then
      plot(x3,y3,rmin3,rm3,c3) else nyputpixel(x3,y3,c3);
    end
    else
    begin
      relativ(x1,y1,x2,y2,x3,y3,xr3,yr3,rr12);
      if fmrk1=1 then
      plot(xr1,0,rmin1,rm1,c1) else nyputpixel(xr1,0,c1);
      if fmrk2=1 then
      plot(xr1+rr12,0,rmin2,rm2,c2) else nyputpixel(xr1+rr12,0,c2);
      if fmrk3=1 then
      plot(xr3,yr3,rmin3,rm3,c3) else nyputpixel(xr3,yr3,c3);
    end;
  end
  else
  begin
    model(x1,y1,x2,y2,x3,y3);
    tabel;
  end;

  if t>tstop-dt/10 then begin svar:=readkey; RestoreCrtMode; exit; end;

  repeat
    rk4b;

    t:=t+dt;

    xg1:=x1; xg2:=x2; xg3:=x3; yg1:=y1; yg2:=y2; yg3:=y3;

    x1:=x1+dx1; y1:=y1+dy1;
    x2:=x2+dx2; y2:=y2+dy2;
    x3:=x3+dx3; y3:=y3+dy3;

    vx1:=vx1+dvx1; vy1:=vy1+dvy1;
    vx2:=vx2+dvx2; vy2:=vy2+dvy2;
    vx3:=vx3+dvx3; vy3:=vy3+dvy3;

    ud;

    delay(sinke);

    if keypressed then
    begin
      svar:=readkey;
      case svar of
        #13,#27:
        begin
          if fgraf=1 then
          begin
            RestoreCrtMode;
            exit;
          end
          else exit;
        end;

        #32:
        if fgraf=1 then
        begin
          str(t:talfelt:taldec,talstreng);
          setcolor(14);
          nyouttextxy(gXstart+0.05*dXomr,gYstart+0.05*dYomr,'t = '+talstreng);
          svar:=readkey;
          if svar in (.#13,#27.) then begin RestoreCrtMode; exit; end;
          setcolor(baggr);
          nyouttextxy(gXstart+0.05*dXomr,gYstart+0.05*dYomr,'t = '+talstreng);
        end
        else
        begin
          svar:=readkey;
          if svar in (.#13,#27.) then begin RestoreCrtMode; exit; end;
        end;
      end;
    end;

  until t>tstop-dt/10;

  svar:=readkey;
  RestoreCrtMode;
end;



procedure indata1(nvari:str12; var vari:real);

const
slet='                                                                     ';
tekst1 = '(ENTER uden input = skip input)';

var   code : integer;
      instr : str12;
      tal1 : real;

begin
  tal1:=vari;
  repeat
    gotoxy(27,6); write(tekst1);
    gotoxy(15,5); write(slet);
    gotoxy(15,5); write(nvari,' = ');
    readln(instr);
    val(instr,vari,code);
  until (code=0) or (instr='');
  if instr='' then vari:=tal1;
end;


procedure indata2(nvari:str12; var vari:shortint);

const
slet='                                                                     ';
tekst1 = '(ENTER uden input = skip input)';

var   code : integer;
      instr : str12;
      tal2 : shortint;

begin
  tal2:=vari;
  repeat
    gotoxy(27,6); write(tekst1);
    gotoxy(15,5); write(slet);
    gotoxy(15,5); write(nvari,' = ');
    readln(instr);
    val(instr,vari,code);
  until (code=0) or (instr='');
  if instr='' then vari:=tal2;
end;


procedure indata3(nvari:str12; var vari:word);

const
slet='                                                                     ';
tekst1 = '(ENTER uden input = skip input)';

var   code : integer;
      instr : str12;
      tal3 : word;

begin
  tal3:=vari;
  repeat
    gotoxy(27,6); write(tekst1);
    gotoxy(15,5); write(slet);
    gotoxy(15,5); write(nvari,' = ');
    readln(instr);
    val(instr,vari,code);
  until (code=0) or (instr='');
  if instr='' then vari:=tal3;
end;



procedure visdata1;

begin
  window(1,1,80,18); textcolor(14); textbackground(1);
  clrscr;
  write('                          *** Data 1 for 3 Kloder ***');

  gotoxy(2,3);  write('1.   (x1,y1)  =  (',
                      xf1:talfelt:taldec,',',yf1:talfelt:taldec,')');
  gotoxy(2,4);  write('2.   (x2,y2)  =  (',
                      xf2:talfelt:taldec,',',yf2:talfelt:taldec,')');
  gotoxy(2,5);  write('3.   (x3,y3)  =  (',
                      xf3:talfelt:taldec,',',yf3:talfelt:taldec,')');
  gotoxy(2,7); write('1. (vx1,vy1)  =  (',
                      vxf1:talfelt:taldec,',',vyf1:talfelt:taldec,')');
  gotoxy(2,8); write('2. (vx2,vy2)  =  (',
                      vxf2:talfelt:taldec,',',vyf2:talfelt:taldec,')');
  gotoxy(2,9); write('3. (vx3,vy3)  =  (',
                      vxf3:talfelt:taldec,',',vyf3:talfelt:taldec,')');
  gotoxy(50,3);  write('1.          m1  = ',m1:talfelt:taldec);
  gotoxy(50,4);  write('2.          m2  = ',m2:talfelt:taldec);
  gotoxy(50,5);  write('3.          m3  = ',m3:talfelt:taldec);
  gotoxy(50,7); write('1.       rmin1  = ',rmin1:talfelt:taldec);
  gotoxy(50,8); write('2.       rmin2  = ',rmin2:talfelt:taldec);
  gotoxy(50,9); write('3.       rmin3  = ',rmin3:talfelt:taldec);
end;



procedure data1;

var   svar1, svar2 : char;

begin
repeat
  svar1:='?';
  visdata1;

  window(1,19,80,25); textcolor(14); textbackground(2);
  clrscr;
  gotoxy(2,2);  write('<ENTER> Tilbage til hovedmenu');
  gotoxy(2,3);  write('<1>     Nye startdata for x,y');
  gotoxy(2,4);  write('<2>     Nye startdata for vx,vy');
  gotoxy(2,6);  write('<5>     Nye startdata = stopdata');
  gotoxy(42,3); write('<3>     Nye data for masser');
  gotoxy(42,4); write('<4>     Nye data for rmin');
  gotoxy(50,7);  write('< >...',svar1);
  svar1:=readkey;

  case svar1 of

  '1': repeat
         window(1,19,80,25); textcolor(14); textbackground(2);
         clrscr;
           gotoxy(23,1); write('*** Nye startdata for x,y ***');
           gotoxy(15,3); write('Data nummer (ENTER = exit)...');
           svar2:=readkey;
           gotoxy(45,3); write(svar2);

         case svar2 of
         '1': begin
                indata1('x1',xf1);
                indata1('y1',yf1);
              end;
         '2': begin
                indata1('x2',xf2);
                indata1('y2',yf2);
              end;
         '3': begin
                indata1('x3',xf3);
                indata1('y3',yf3);
              end;
         else
         end; (* case svar2 *)
         visdata1;
       until svar2=#13;

  '2': repeat
         window(1,19,80,25); textcolor(14); textbackground(2);
         clrscr;
           gotoxy(23,1); write('*** Nye startdata for vx,vy ***');
           gotoxy(15,3); write('Data nummer (ENTER = exit)...');
           svar2:=readkey;
           gotoxy(45,3); write(svar2);

         case svar2 of
         '1': begin
                indata1('vx1',vxf1);
                indata1('vy1',vyf1);
              end;
         '2': begin
                indata1('vx2',vxf2);
                indata1('vy2',vyf2);
              end;
         '3': begin
                indata1('vx3',vxf3);
                indata1('vy3',vyf3);
              end;
         else
         end; (* case svar2 *)
         visdata1;
       until svar2=#13;

  '5': begin
         tstart:=t;
         xf1:=x1; yf1:=y1;
         xf2:=x2; yf2:=y2;
         xf3:=x3; yf3:=y3;
         vxf1:=vx1; vyf1:=vy1;
         vxf2:=vx2; vyf2:=vy2;
         vxf3:=vx3; vyf3:=vy3;
       end;

  '3': repeat
         window(1,19,80,25); textcolor(14); textbackground(2);
         clrscr;
           gotoxy(23,1); write('*** Nye data for m ***');
           gotoxy(15,3); write('Data nummer (ENTER = exit)...');
           svar2:=readkey;
           gotoxy(45,3); write(svar2);

         case svar2 of
         '1': indata1('m1',m1);
         '2': indata1('m2',m2);
         '3': indata1('m3',m3);
         else
         end; (* case svar2 *)
         visdata1;
       until svar2=#13;

  '4': repeat
         window(1,19,80,25); textcolor(14); textbackground(2);
         clrscr;
           gotoxy(23,1); write('*** Nye data for rmin ***');
           gotoxy(15,3); write('Data nummer (ENTER = exit)...');
           svar2:=readkey;
           gotoxy(45,3); write(svar2);

         case svar2 of
         '1': indata1('rmin1',rmin1);
         '2': indata1('rmin2',rmin2);
         '3': indata1('rmin3',rmin3);
         else
         end; (* case svar2 *)
         visdata1;
       until svar2=#13;

  else
  end; (* case svar1 *)
until (svar1=#13) or (svar1=#27);
end;



procedure visdata2;

begin
  window(1,1,80,18); textcolor(14); textbackground(1);
  clrscr;
  write('                          *** Data 2 for 3 Kloder ***');
  gotoxy(2,3); write('Data for flag');
  gotoxy(2,5); write('1.       fmrk1  = ',fmrk1:6);
  gotoxy(2,6); write('2.       fmrk2  = ',fmrk2:6);
  gotoxy(2,7); write('3.       fmrk3  = ',fmrk3:6);
  gotoxy(2,8); write('4.      fksrel  = ',fksrel:6);
  gotoxy(2,9); write('5.       fgraf  = ',fgraf:6);
  gotoxy(2,12); write('Data for tid');
  gotoxy(2,14); write('1.      tstart  = ',tstart:talfelt:taldec);
  gotoxy(2,15); write('2.       tstop  = ',tstop:talfelt:taldec);
  gotoxy(2,16); write('3.          dt  = ',dt:talfelt:taldec);
  gotoxy(42,3); write('Data for KS');
  gotoxy(42,5); write('1.        xmin  = ',xmin:talfelt:taldec);
  gotoxy(42,6); write('          xmax  = ',xmax:talfelt:taldec);
  gotoxy(42,7); write('2.        ymin  = ',ymin:talfelt:taldec);
  gotoxy(42,8); write('3.         xr1  = ',xr1:talfelt:taldec);
  gotoxy(42,9); write('4.         fyx  = ',fyx:talfelt:taldec);
  gotoxy(42,12); write('Data for andet');
  gotoxy(42,14); write('1.     talfelt  = ',talfelt:6);
  gotoxy(42,15); write('2.      taldec  = ',taldec:6);
  gotoxy(42,16); write('3.       sinke  = ',sinke:6);
end;



procedure data2;

var   svar1, svar2 : char;

begin
repeat
  svar1:='?';
  visdata2;

  window(1,19,80,25); textcolor(14); textbackground(2);
  clrscr;
  gotoxy(2,2);  write('<ENTER> Tilbage til hovedmenu');
  gotoxy(2,3);  write('<1>     Nye data for flag');
  gotoxy(2,4);  write('<2>     Nye data for tid');
  gotoxy(42,3); write('<3>     Nye data for KS');
  gotoxy(42,4); write('<4>     Nye data for andet');
  gotoxy(50,6);  write('< >...',svar1);
  svar1:=readkey;

  case svar1 of

  '1': repeat
         window(1,19,80,25); textcolor(14); textbackground(2);
         clrscr;
           gotoxy(23,1); write('*** Nye data for flag (toggle) ***');
           gotoxy(15,3); write('Data nummer (ENTER = exit)');
           svar2:=readkey;
           gotoxy(45,3); write(svar2);

         case svar2 of
         '1': if fmrk1=0 then fmrk1:=1 else fmrk1:=0;
         '2': if fmrk2=0 then fmrk2:=1 else fmrk2:=0;
         '3': if fmrk3=0 then fmrk3:=1 else fmrk3:=0;
         '4': if fksrel=0 then fksrel:=1 else fksrel:=0;
         '5': if fgraf=0 then fgraf:=1 else fgraf:=0;
         else
         end; (* case svar2 *)
         visdata2;
       until svar2=#13;

  '2': repeat
         window(1,19,80,25); textcolor(14); textbackground(2);
         clrscr;
           gotoxy(23,1); write('*** Nye data for tid ***');
           gotoxy(15,3); write('Data nummer (ENTER = exit)...');
           svar2:=readkey;
           gotoxy(45,3); write(svar2);

         case svar2 of
         '1': indata1('tstart',tstart);
         '2': indata1('tstop',tstop);
         '3': indata1('dt',dt);
         else
         end; (* case svar2 *)
         visdata2;
       until svar2=#13;

  '3': repeat
         window(1,19,80,25); textcolor(14); textbackground(2);
         clrscr;
           gotoxy(23,1); write('*** Nye data for KS ***');
           gotoxy(15,3); write('Data nummer (ENTER = exit)...');
           svar2:=readkey;
           gotoxy(45,3); write(svar2);

         case svar2 of
         '1': begin
                indata1('xmin',xmin);
                indata1('xmax',xmax);
                ymin:=-(xmax-xmin)*fyx/2;
              end;
         '2': indata1('ymin',ymin);
         '3': indata1('xr1',xr1);
         '4': begin
                indata1('fyx',fyx);
                ymin:=-(xmax-xmin)*fyx/2;
              end;
         else
         end; (* case svar2 *)
         visdata2;
       until svar2=#13;


  '4': repeat
         window(1,19,80,25); textcolor(14); textbackground(2);
         clrscr;
           gotoxy(23,1); write('*** Nye data for andet ***');
           gotoxy(15,3); write('Data nummer (ENTER = exit)...');
           svar2:=readkey;
           gotoxy(45,3); write(svar2);

         case svar2 of
         '1': indata2('talfelt',talfelt);
         '2': indata2('taldec',taldec);
         '3': indata3('sinke',sinke);
         else
         end; (* case svar2 *)
         visdata2;
       until svar2=#13;

  else
  end; (* case svar1 *)
until (svar1=#13) or (svar1=#27);
end;



procedure visprintdata;

begin
  window(1,1,80,18); textcolor(14); textbackground(1);
  clrscr;
  write('              *** Information og udskrift af data for 3 Kloder ***');
  gotoxy(5,4); write('Information om data:');
  gotoxy(5,6); write(inf);
end;



procedure printdata;

var  svar1 : char;
     i,fpr : byte;
     tal1 : string(.strl.);

begin
repeat
  svar1:='?';
  visprintdata;

  window(1,19,80,25); textcolor(14); textbackground(2);
  clrscr;
  gotoxy(2,2);  write('<ENTER> Tilbage til hovedmenu');
  gotoxy(2,3);  write('<1>     Start print');
  gotoxy(2,4);  write('<2>     Ny information om data');
  gotoxy(50,6);  write('< >...',svar1);
  svar1:=readkey;

  case svar1 of
    '1':
    begin
      window(1,19,80,25); textcolor(14); textbackground(2);
      clrscr;
      fpr:=1;
      (*$I-*) writeln(lst); (*$I+*)
      if IOresult<>0 then
      begin
        fpr:=0;
        gotoxy(5,4); write('Printer er ikke tilsluttet, tast <ENTER>');
        svar:=readkey;
      end;

      if fpr=1 then
      begin
        writeln(lst,'                          *** Data for 3 Kloder ***');
        writeln(lst); writeln(lst);
        writeln(lst,'  Bibliotek: ',NDF);
        writeln(lst,'  Filnavn: ',NFil);
        writeln(lst,'  ',inf); writeln(lst);  writeln(lst);

        writeln(lst,'     (x1,y1)  =  (',
                            xf1:talfelt:taldec,',',yf1:talfelt:taldec,')');
        writeln(lst,'     (x2,y2)  =  (',
                            xf2:talfelt:taldec,',',yf2:talfelt:taldec,')');
        writeln(lst,'     (x3,y3)  =  (',
                            xf3:talfelt:taldec,',',yf3:talfelt:taldec,')');
        writeln(lst);
        writeln(lst,'   (vx1,vy1)  =  (',
                            vxf1:talfelt:taldec,',',vyf1:talfelt:taldec,')');
        writeln(lst,'   (vx2,vy2)  =  (',
                            vxf2:talfelt:taldec,',',vyf2:talfelt:taldec,')');
        writeln(lst,'   (vx3,vy3)  =  (',
                            vxf3:talfelt:taldec,',',vyf3:talfelt:taldec,')');
        writeln(lst);
        writeln(lst,'          m1  = ',m1:talfelt:taldec);
        writeln(lst,'          m2  = ',m2:talfelt:taldec);
        writeln(lst,'          m3  = ',m3:talfelt:taldec);
        writeln(lst);
        writeln(lst,'       rmin1  = ',rmin1:talfelt:taldec);
        writeln(lst,'       rmin2  = ',rmin2:talfelt:taldec);
        writeln(lst,'       rmin3  = ',rmin3:talfelt:taldec);
        writeln(lst);
        writeln(lst,'       fmrk1  = ',fmrk1:6);
        writeln(lst,'       fmrk2  = ',fmrk2:6);
        writeln(lst,'       fmrk3  = ',fmrk3:6);
        writeln(lst,'       fgraf  = ',fgraf:6);
        writeln(lst,'      fksrel  = ',fksrel:6);

        writeln(lst);
        writeln(lst,'      tstart  = ',tstart:talfelt:taldec);
        writeln(lst,'       tstop  = ',tstop:talfelt:taldec);
        writeln(lst,'          dt  = ',dt:talfelt:taldec);
        writeln(lst);
        writeln(lst,'        xmin  = ',xmin:talfelt:taldec,
        '        xmax  = ',xmax:talfelt:taldec);
        writeln(lst,'        ymin  = ',ymin:talfelt:taldec);
        writeln(lst,'         xr1  = ',xr1:talfelt:taldec);
        writeln(lst,'         fyx  = ',fyx:talfelt:taldec);
        writeln(lst);
        writeln(lst,'     talfelt  = ',talfelt:6);
        writeln(lst,'      taldec  = ',taldec:6);
        writeln(lst,'       sinke  = ',sinke:6);
        writeln(lst,#12);
      end;
    end;

    '2':
    begin
      window(1,19,80,25); textcolor(14); textbackground(2);
      clrscr;
      tal1:=inf;
      gotoxy(27,6); write('(ENTER uden input = skip input)');
      gotoxy(5,3); write('Skriv information om data (max ',strl,' tegn):');
      gotoxy(5,5);
      readln(inf);
      if inf='' then inf:=tal1;
      for i:=1 to strl-length(inf) do inf:=inf+' ';
    end;
    else
  end;

  visprintdata;
until (svar1=#13) or (svar1=#27);
end;




procedure visdatafil;

  const NN = 75;

  var   i : byte;

begin
  window(1,1,80,20); textcolor(14); textbackground(1);
  clrscr;
  writeln('                         *** Datafiler for 3 Kloder ***   ');
  writeln('Bibliotek: ',NDF);
  writeln(NFil+'  '+inf);
  if pfil=1 then
  begin
    findfirst(NDirFil+'*.*',anyfile,srec);
    findnext(srec); findnext(srec);
  end;
  write('                                                                              ');

  i:=1;
  while (i<=NN) and (doserror=0) do
  begin
    write(srec.name:16);
    findnext(srec);
    i:=i+1;
  end;
  if doserror<>0 then pfil:=0;
  writeln;
end;



procedure datafil;

const  blk1 = #32;
       ct1  = #13;
slet='                                                                     ';
       tekst1 = '(ENTER uden input = exit)';


var    svar1,blk2,ct2 : char;
       tal1 : infstr;
       DatFil : text;

begin
repeat
  svar1:='?';
  visdatafil;

  window(1,21,80,25); textcolor(14); textbackground(2);
  clrscr;
  gotoxy(2,2);  write('<ENTER> Tilbage til hovedmenu');
  gotoxy(2,3);  write('<1>     Hent datafil');
  gotoxy(2,4);  write('<2>     Gem datafil');
  gotoxy(42,3); write('<3>     Flere datafiler');
  gotoxy(42,4); write('<4>     Nyt bibliotek');
  gotoxy(50,5); write('< >...',svar1);
  svar1:=readkey;

  case svar1 of

    '1': (* Hent datafil *)
    begin
      window(1,21,80,25); textcolor(14); textbackground(2);
      clrscr;
      gotoxy(31,1);  write('*** Hent datafil ***');
      repeat
        gotoxy(35,4); write(tekst1);
        gotoxy(15,3); write(slet);
        gotoxy(15,3); write('Datafils navn : ');
        readln(NFil);
        if NFil<>'' then
        begin
          assign(DatFil,NDirFil+NFil);
          (*$I-*)
          reset(DatFil);
          read(DatFil,inf,ct2,
               xf1,blk2,yf1,ct2,xf2,blk2,yf2,ct2,xf3,blk2,yf3,ct2,
               vxf1,blk2,vyf1,ct2,vxf2,blk2,vyf2,ct2,vxf3,blk2,vyf3,ct2,
               m1,blk2,m2,blk2,m3,ct2,rmin1,blk2,rmin2,blk2,rmin3,ct2,
               fmrk1,blk2,fmrk2,blk2,fmrk3,blk2,fksrel,blk2,fgraf,ct2,
               tstart,blk2,tstop,blk2,dt,ct2,
               xmin,blk2,xmax,blk2,ymin,ct2,xr1,blk2,fyx,ct2,
               talfelt,blk2,taldec,blk2,sinke);
          (*$I+*)
        end;
      until (IOresult=0) or (NFil='');
      if NFil<>'' then close(DatFil);
      pfil:=1;
    end;

    '2': (* Gem datafil *)
    begin
      window(1,21,80,25); textcolor(14); textbackground(2);
      clrscr;
      gotoxy(31,1);  write('*** Gem datafil ***');
      gotoxy(35,4); write(tekst1);
      gotoxy(15,3); write(slet);
      gotoxy(15,3); write('Datafils navn : ');
      readln(NFil);
      if NFil<>'' then
      begin
        assign(DatFil,NDirFil+NFil);
        rewrite(DatFil);
        write(DatFil,inf:strl,ct1,
              xf1,blk1,yf1,ct1,xf2,blk1,yf2,ct1,xf3,blk1,yf3,ct1,
              vxf1,blk1,vyf1,ct1,vxf2,blk1,vyf2,ct1,vxf3,blk1,vyf3,ct1,
              m1,blk1,m2,blk1,m3,ct1,rmin1,blk1,rmin2,blk1,rmin3,ct1,
              fmrk1,blk1,fmrk2,blk1,fmrk3,blk1,fksrel,blk1,fgraf,ct1,
              tstart,blk1,tstop,blk1,dt,ct1,
              xmin,blk1,xmax,blk1,ymin,ct1,xr1,blk1,fyx,ct1,
              talfelt,blk1,taldec,blk1,sinke);
        close(DatFil);
      end;
      pfil:=1;
    end;

    '3': pfil:=pfil+1;

    '4':
    begin
      window(1,21,80,25); textcolor(14); textbackground(2);
      clrscr;
      tal1:=NDF;
      gotoxy(30,4); write('(ENTER uden input = skip input)');
      gotoxy(5,2); write('Bibliotek (max ',strl,' tegn): ');
      readln(NDF);
      if NDF='' then NDF:=tal1;
      NDirFil:=NDF+'\';
      pfil:=1;
    end;

  else  pfil:=1;
  end;

until (svar1=#13) or (svar1=#27);
pfil:=1;
end;




procedure hovedmenu;

  var   svar   : char;
        iii    : byte;

begin
  repeat
    window(1,1,80,25); textcolor(14); textbackground(0);
    clrscr;
    svar:='?';
    gotoxy(10,1);  write('                       *** 3 Kloder ***');
    gotoxy(5,3);  write('Program til bogen "Planeter", af Kaare Lund Rasmussen og Torsten Meyer,');
    gotoxy(29,4);  write('Munksgaards  Dimensioner');
    gotoxy(1,5); for iii:=1 to 80 do write('-');
    gotoxy(15,7);  write('<ESC>  Forlad programmet');
    gotoxy(15,9);  write('<1>    Simulering');
    gotoxy(15,11); write('<2>    Data1: Klode-parametre');
    gotoxy(15,13); write('<3>    Data2: Flag, KS, m.m.');
    gotoxy(15,15); write('<4>    Information og udskrift af data');
    gotoxy(15,17); write('<5>    Datafiler');
    gotoxy(1,21); for iii:=1 to 80 do write('-');
    gotoxy(2,22);  write('Taster under  <1> Simulering:');
    gotoxy(40,22); write('ENTER    : afbryder');
    gotoxy(40,23); write('MELLEMRUM: pause + tid / fortst');
    gotoxy(2,25);  write('Ls GENEREL.DOC og KLODER3.DOC');
    gotoxy(48,19); write('< >...',svar);
    svar:=readkey;
    clrscr;

    case svar of
      '1': simulering;
      '2': data1;
      '3': data2;
      '4': printdata;
      '5': datafil;
    else
    end;

  until svar=#27;
end;




begin (* main *)
  start;
  grafini;
  repeat
    hovedmenu;
    clrscr;
    gotoxy(10,10); write('Vil du forlade programmet? (j/n) ');
    readln(svar);
  until svar in (.'j','J'.);
  clrscr;
end.

