program klodern;

{$N+,E+}

uses  crt, printer, dos, graph, koovin8;

const strl=65;
      Nmax = 21; N4max = 4*Nmax;

type  TalArray1  = array(.1..Nmax.) of real;
      TalArray14 = array(.1..N4max.) of real;
      TalArray2  = array(.1..Nmax,1..Nmax.) of real;
      str15 = string[15];
      str12 = string[12];
      str2 = string[2];
      infstr = string[strl];

var   xf,yf,vxf,vyf,xg,yg,ax,ay : talarray1;
      le,dledt : talarray14;
      m,rmin : talarray1;
      t,dt,tstop,tstart,dt2,dt6,G : real;
      N,N4,fmrk,fgraf,fprint,baggr,pdata,pfil,praf : byte;
      xmin,xmax,ymin,ymax,fyx : real;
      xrafmin,xrafmax,vrafmin,vrafmax,mrafmin,mrafmax : real;
      GraphDriver, Graphmode, ErrCode : integer;
      svar : char;
      sinke : word;
      talfelt,taldec : shortint;
      inf,NDirFil,NDF : infstr;
      NFil : str15;
      srec : searchrec;


procedure start;

var  i : byte;

begin

  G:=4*pi*pi;
  N:=14; N4:=4*N;

  for i:=1 to Nmax do
  begin
    m(.i.):=0;
    xf(.i.):=i-1;
    yf(.i.):=0;
    vxf(.i.):=0;
    if i<>1 then vyf(.i.):=2*pi*sqrt(1/(i-1));
    rmin(.i.):=0.05;
  end;

  m(.1.):=1;
  xf(.1.):=0;
  vyf(.1.):=0;

  xmin:=-20; xmax:=20;
  fyx:=0.75; ymin:=-(xmax-xmin)*fyx/2;
  fmrk:=0; fgraf:=1; fprint:=0;
  pdata:=0; pfil:=1; praf:=0;

  tstart:=0;  tstop:=1000; dt:=0.01;

  talfelt:=10; taldec:=3;
  sinke:=0;

  inf:='Basisdata';
  for i:=1 to strl-length(inf) do inf:=inf+' ';

  NDF:='klndata'; NDirFil:=NDF+'\';
  NFil:='kln.000';

  xrafmin:=-10; xrafmax:=10;
  vrafmin:=-2;  vrafmax:=2;
  mrafmin:=0; mrafmax:=1;

  FOR i:=1 TO N4 DO le(.i.):=0;
  t:=0;
end;



procedure model;

var  i,j : byte;
     x,y,vx,vy : talarray1;
     r,cr,dr : talarray2;

begin
  for i:=1 to N do
  begin
    x(.i.):=le(.4*i-3.);
    y(.i.):=le(.4*i-2.);
    vx(.i.):=le(.4*i-1.);
    vy(.i.):=le(.4*i.);
  end;

  for i:=1 to N do
    for j:=1 to N do
    begin
      cr(.i,j.):=sqr(x(.i.)-x(.j.))+sqr(y(.i.)-y(.j.));
      r(.i,j.):=sqrt(cr(.i,j.));
      if r(.i,j.)<rmin(.i.)+rmin(.j.)
        then cr(.i,j.):=(rmin(.i.)+rmin(.j.))*(rmin(.i.)+rmin(.j.));
      dr(.i,j.):=cr(.i,j.)*r(.i,j.);
    end;

  for i:=1 to N do
  begin
    dledt(.4*i-3.):=vx(.i.);
    dledt(.4*i-2.):=vy(.i.);
    ax(.i.):=0;
    ay(.i.):=0;
    for j:=1 to N do
      if j<>i then
      begin
        ax(.i.):=ax(.i.)+G*m(.j.)*(x(.j.)-x(.i.))/dr(.i,j.);
        ay(.i.):=ay(.i.)+G*m(.j.)*(y(.j.)-y(.i.))/dr(.i,j.);
      end;
    dledt(.4*i-1.):=ax(.i.);
    dledt(.4*i.):=ay(.i.);
  end;
end;


procedure grafini;
begin
  GraphDriver := Detect;
  InitGraph(GraphDriver,GraphMode,'');
  ErrCode := GraphResult;
  if ErrCode<>grOk then
  begin
    Writeln('Graphics error:', GraphErrorMsg(ErrCode));
    halt;
  end;
  SetBkColor(0);
  baggr:=GetBkColor;
  RestoreCrtMode;
end;


procedure plot;
  var i : byte;
begin
  if fmrk=0 then
    for i:=1 to N do nyputpixel(le(.4*i-3.),le(.4*i-2.),(i mod 7)+9)
  else
    for i:=1 to N do
    begin
      setcolor((i mod 7)+9); nycircle(le(.4*i-3.),le(.4*i-2.),rmin(.i.));
    end;
end;


procedure afplot;
  var i : byte;
begin
  for i:=1 to N do
  begin
    setcolor(baggr); nycircle(xg(.i.),yg(.i.),rmin(.i.));
  end;
end;


procedure tabel;

var i: byte;

begin
  if fprint=0 then
  for i:=1 to N do
    writeln('t = ',t:talfelt:taldec,
            '   x(',i:2,') = ',le(.4*i-3.):talfelt:taldec,
            '   y(',i:2,') = ',le(.4*i-2.):talfelt:taldec)
  else
  for i:=1 to N do
    writeln(lst,'t = ',t:talfelt:taldec,
            '   x(',i:2,') = ',le(.4*i-3.):talfelt:taldec,
            '   y(',i:2,') = ',le(.4*i-2.):talfelt:taldec);
end;


procedure rk4;
  var j : byte;
      Le0,dLedt1,dLedt2,dLedt3,dLedt4 : TalArray14;
      t0 : real;
begin

  FOR j:=1 TO N4 DO
    le0(.j.):=le(.j.);
  t0:=t;

  model;

  FOR j:=1 TO N4 DO
  begin
    dledt1(.j.):=dledt(.j.);
    le(.j.):=le0(.j.)+dledt1(.j.)*dt2;
  end;
  t:=t0+dt2;

  model;

  FOR j:=1 TO N4 DO
  begin
    dledt2(.j.):=dledt(.j.);
    le(.j.):=le0(.j.)+dledt2(.j.)*dt2;
  end;

  model;

  FOR j:=1 TO N4 DO
  begin
    dledt3(.j.):=dledt(.j.);
    le(.j.):=le0(.j.)+dledt3(.j.)*dt;
  end;
  t:=t0+dt;

  model;

  FOR j:=1 TO N4 DO
  begin
    dledt4(.j.):=dledt(.j.);
    le(.j.):=le0(.j.)+(dledt1(.j.)+2*dledt2(.j.)
                                      +2*dledt3(.j.)+dledt4(.j.))*dt6;
  end;

end;



procedure simulering;

var  i         : word;
     talstreng : string;
begin

  N4:=4*N;

  for i:=1 to N do
  begin
    le(.4*i-3.):=xf(.i.);
    le(.4*i-2.):=yf(.i.);
    le(.4*i-1.):=vxf(.i.);
    le(.4*i.):=vyf(.i.);
  end;

  t:=tstart; dt2:=dt/2; dt6:=dt/6;

  clrscr;

  if fgraf=1 then
  begin
    ymax:=ymin+(xmax-xmin)*fyx;
    ks(xmin,xmax,ymin,ymax,talfelt,taldec);
    plot;
  end
  else begin model; tabel; end;

  if t>tstop-dt/10 then begin svar:=readkey; RestoreCrtMode; exit; end;

  repeat
    for i:=1 to N do
    begin
      xg(.i.):=le(.4*i-3.);
      yg(.i.):=le(.4*i-2.);
    end;

    rk4;

    if fgraf=1 then
    begin
      if fmrk=1 then afplot;
      plot;
    end
    else begin model; tabel; end;

    delay(sinke);

    if keypressed then
    begin
      svar:=readkey;
      case svar of
        #13,#27: begin RestoreCrtMode; exit; end;
        #32:
        if fgraf=1 then
        begin
          str(t:talfelt:taldec,talstreng);
          setcolor(14);
          nyouttextxy(gXstart+0.05*dXomr,gYstart+0.05*dYomr,'t = '+talstreng);
          svar:=readkey;
          if svar in (.#13,#27.) then begin RestoreCrtMode; exit; end;
          setcolor(baggr);
          nyouttextxy(gXstart+0.05*dXomr,gYstart+0.05*dYomr,'t = '+talstreng);
        end
        else
        begin
          svar:=readkey;
          if svar in (.#13,#27.) then begin RestoreCrtMode; exit; end;
        end;
      end;
    end;

  until t>tstop-dt/10;
  svar:=readkey;
  RestoreCrtMode;
end;



procedure indata1(nvari:str12; var vari:real);

const
slet='                                                                     ';
tekst1 = '(ENTER uden input = skip input)';

var   code : integer;
      instr : str12;
      tal1 : real;

begin
  tal1:=vari;
  repeat
    gotoxy(27,6); write(tekst1);
    gotoxy(15,5); write(slet);
    gotoxy(15,5); write(nvari,' = ');
    readln(instr);
    val(instr,vari,code);
  until (code=0) or (instr='');
  if instr='' then vari:=tal1;
end;


procedure indata2(nvari:str12; var vari:shortint);

const
slet='                                                                     ';
tekst1 = '(ENTER uden input = skip input)';

var   code : integer;
      instr : str12;
      tal2 : shortint;

begin
  tal2:=vari;
  repeat
    gotoxy(27,6); write(tekst1);
    gotoxy(15,5); write(slet);
    gotoxy(15,5); write(nvari,' = ');
    readln(instr);
    val(instr,vari,code);
  until (code=0) or (instr='');
  if instr='' then vari:=tal2;
end;


procedure indata3(nvari:str12; var vari:word);

const
slet='                                                                     ';
tekst1 = '(ENTER uden input = skip input)';

var   code : integer;
      instr : str12;
      tal3 : word;

begin
  tal3:=vari;
  repeat
    gotoxy(27,6); write(tekst1);
    gotoxy(15,5); write(slet);
    gotoxy(15,5); write(nvari,' = ');
    readln(instr);
    val(instr,vari,code);
  until (code=0) or (instr='');
  if instr='' then vari:=tal3;
end;




procedure visdata1;

var  i,j,NN : byte;

begin
  window(1,1,80,18); textcolor(14); textbackground(1);
  clrscr;
  write('                         *** Data 1 for N Kloder ***');
  j:=pdata*7;
  if (pdata+1)*7>N then NN:=N-7*pdata else NN:=7;

  for i:=1 to NN do
  begin
    gotoxy(2,2+i); write('(x,y)   (',i+j:2,') = (',xf(.i+j.):talfelt:taldec,
                         ',',yf(.i+j.):talfelt:taldec,')');
    gotoxy(2,3+NN+i); write('(vx,vy) (',i+j:2,') = (',vxf(.i+j.):talfelt:taldec,
                         ',',vyf(.i+j.):talfelt:taldec,')');
    gotoxy(50,2+i); write('m   (',i+j:2,') = ',m(.i+j.):talfelt:taldec);
    gotoxy(50,3+NN+i); write('rmin(',i+j:2,') = ',rmin(.i+j.):talfelt:taldec);
  end;
end;



procedure data1;

var   svar1 : char;
      i,m7 : byte;
      code : integer;
      instr : str12;
      is : str2;

begin
  repeat
    svar1:='?';
    visdata1;

    window(1,19,80,25); textcolor(14); textbackground(2);
    clrscr;
    gotoxy(2,2);  write('<ENTER> Tilbage til hovedmenu');
    gotoxy(2,3);  write('<1>     Nye startdata for x,y');
    gotoxy(2,4);  write('<2>     Nye startdata for vx,vy');
    gotoxy(2,6);  write('<5>     Nye startdata = stopdata');
    gotoxy(42,3); write('<3>     Nye data for m');
    gotoxy(42,4); write('<4>     Nye data for rmin');
    if N>7 then
    begin
      gotoxy(42,6);  write('<6>     Data for flere kloder');
    end;

    gotoxy(50,7);  write('< >...',svar1);
    svar1:=readkey;

    case svar1 of

      '1':
      repeat
        repeat
          window(1,19,80,25); textcolor(14); textbackground(2);
          clrscr;
          gotoxy(23,1);  write('*** Startdata for x,y ***');
          gotoxy(15,3);  write('Klode nummer (ENTER = exit)...');
          readln(instr);
          val(instr,i,code);
        until ((code=0) and (i>0) and (i<=N))   or (instr='');
        if instr<>'' then
        begin
          str(i:2,is);
          indata1('x('+is+')',xf(.i.));
          indata1('y('+is+')',yf(.i.));
          visdata1;
        end;
      until instr='';

      '2':
      repeat
        repeat
          window(1,19,80,25); textcolor(14); textbackground(2);
          clrscr;
          gotoxy(23,1);  write('*** Startdata for vx,vy ***');
          gotoxy(15,3);  write('Klode nummer (ENTER = exit)...');
          readln(instr);
          val(instr,i,code);
        until ((code=0) and (i>0) and (i<=N))   or (instr='');
        if instr<>'' then
        begin
          str(i:2,is);
          indata1('vx('+is+')',vxf(.i.));
          indata1('vy('+is+')',vyf(.i.));
          visdata1;
        end;
      until instr='';

      '5':
      begin
        tstart:=t;
        for i:=1 to N do
        begin
          xf(.i.):=le(.4*i-3.);
          yf(.i.):=le(.4*i-2.);
          vxf(.i.):=le(.4*i-1.);
          vyf(.i.):=le(.4*i.);
        end;
      end;

      '3':
      repeat
        repeat
          window(1,19,80,25); textcolor(14); textbackground(2);
          clrscr;
          gotoxy(23,1);  write('*** Startdata for m ***');
          gotoxy(15,3);  write('Klode nummer (ENTER = exit)...');
          readln(instr);
          val(instr,i,code);
        until ((code=0) and (i>0) and (i<=N))   or (instr='');
        if instr<>'' then
        begin
          str(i:2,is);
          indata1('m('+is+')',m(.i.));
          visdata1;
        end;
      until instr='';

      '4':
      repeat
        repeat
          window(1,19,80,25); textcolor(14); textbackground(2);
          clrscr;
          gotoxy(23,1);  write('*** Startdata for rmin ***');
          gotoxy(15,3);  write('Klode nummer (ENTER = exit)...');
          readln(instr);
          val(instr,i,code);
        until ((code=0) and (i>0) and (i<=N))   or (instr='');
        if instr<>'' then
        begin
          str(i:2,is);
          indata1('rmin('+is+')',rmin(.i.));
          visdata1;
        end;
      until instr='';

      '6':
      begin
        m7:=(N-1) div 7;
        pdata:=(pdata+1) mod (m7+1);
      end;

      else;
    end;
  until (svar1=#13) or (svar1=#27);
end;



procedure visdata2;

var  i : byte;

begin
  window(1,1,80,18); textcolor(14); textbackground(1);
  clrscr;
  write('                         *** Data 2 for N Kloder ***');
  gotoxy(2,3);   write('Antal kloder');
  gotoxy(2,4);   write('*            N  = ',N:6);
  gotoxy(2,8);   write('Data for flag');
  gotoxy(2,9);   write('1         fmrk  = ',fmrk:6);
  gotoxy(2,10);   write('2        fgraf  = ',fgraf:6);
  gotoxy(2,14);  write('Data for tid');
  gotoxy(2,15);  write('1.      tstart  = ',tstart:talfelt:taldec);
  gotoxy(2,16);  write('2.       tstop  = ',tstop:talfelt:taldec);
  gotoxy(2,17);  write('3.          dt  = ',dt:talfelt:taldec);
  gotoxy(42,3);  write('Data for KS');
  gotoxy(42,4);  write('1.        xmin  = ',xmin:talfelt:taldec);
  gotoxy(42,5);  write('          xmax  = ',xmax:talfelt:taldec);
  gotoxy(42,6);  write('2.        ymin  = ',ymin:talfelt:taldec);
  gotoxy(42,7);  write('3.         fyx  = ',fyx:talfelt:taldec);
  gotoxy(42,14); write('Data for andet');
  gotoxy(42,15); write('1.     talfelt  = ',talfelt:6);
  gotoxy(42,16); write('2.      taldec  = ',taldec:6);
  gotoxy(42,17); write('3.       sinke  = ',sinke:6);

end;



procedure data2;

const
slet='                                                                     ';
tekst1 = '(ENTER uden input = skip input)';

var   svar1, svar2 : char;
      code : integer;
      instr : string[12];
      tal4 : byte;

begin
  repeat
    svar1:='?';
    visdata2;

    window(1,19,80,25); textcolor(14); textbackground(2);
    clrscr;
    gotoxy(2,2);  write('<ENTER> Tilbage til hovedmenu');
    gotoxy(2,3);  write('<1>     Nye data for antal kloder');
    gotoxy(2,4);  write('<2>     Nye data for flag (toggle)');
    gotoxy(2,5);  write('<3>     Nye data for tid');
    gotoxy(42,3); write('<4>     Nye data for KS');
    gotoxy(42,4); write('<5>     Nye data for andet');
    gotoxy(50,6); write('< >...',svar1);
    svar1:=readkey;

    case svar1 of

      '1':
      begin
        window(1,19,80,25); textcolor(14); textbackground(2);
        clrscr;
        gotoxy(23,1); write('*** Nye data for antal kloder ***');
        tal4:=N;
        repeat
          gotoxy(27,6); write(tekst1);
          gotoxy(15,5); write(slet);
          gotoxy(15,5); write('N (max ',Nmax,') = ');
          readln(instr);
          val(instr,N,code);
        until ((code=0) and (N>0) and (N<=Nmax)) or (instr='');
        if instr='' then N:=tal4;
        pdata:=0;
      end;

      '2':
      repeat
        window(1,19,80,25); textcolor(14); textbackground(2);
        clrscr;
          gotoxy(23,1); write('*** Nye data for flag (toggle) ***');
          gotoxy(15,3); write('Data nummer (ENTER = exit)');
          svar2:=readkey;
          gotoxy(45,3); write(svar2);

        case svar2 of
        '1': if fmrk=0 then fmrk:=1 else fmrk:=0;
        '2': if fgraf=0 then fgraf:=1 else fgraf:=0;
        else
        end; (* case svar2 *)
        visdata2;
      until svar2=#13;


      '3':
      repeat
        window(1,19,80,25); textcolor(14); textbackground(2);
        clrscr;
        gotoxy(23,1); write('*** Nye data for tid ***');
        gotoxy(15,3); write('Data nummer (ENTER = exit)...');
        svar2:=readkey;
        gotoxy(45,3); write(svar2);

        case svar2 of
         '1': indata1('tstart',tstart);
         '2': indata1('tstop',tstop);
         '3': indata1('dt',dt);
        else
        end; (* case svar2 *)
        visdata2;
      until svar2=#13;

      '4':
      repeat
        window(1,19,80,25); textcolor(14); textbackground(2);
        clrscr;
        gotoxy(23,1); write('*** Nye data for KS ***');
        gotoxy(15,3); write('Data nummer (ENTER = exit)...');
        svar2:=readkey;
        gotoxy(45,3); write(svar2);

        case svar2 of
         '1': begin
                indata1('xmin',xmin);
                indata1('xmax',xmax);
                ymin:=-(xmax-xmin)*fyx/2;
              end;
         '2': indata1('ymin',ymin);
         '3': begin
                indata1('fyx',fyx);
                ymin:=-(xmax-xmin)*fyx/2;
              end;
        else
        end; (* case svar2 *)
        visdata2;
      until svar2=#13;

      '5':
      repeat
        window(1,19,80,25); textcolor(14); textbackground(2);
        clrscr;
        gotoxy(23,1); write('*** Nye data for andet ***');
        gotoxy(15,3); write('Data nummer (ENTER = exit)...');
        svar2:=readkey;
        gotoxy(45,3); write(svar2);

        case svar2 of
         '1': indata2('talfelt',talfelt);
         '2': indata2('taldec',taldec);
         '3': indata3('sinke',sinke);
        else
        end; (* case svar2 *)
        visdata2;
      until svar2=#13;

      else;
    end;
  until (svar1=#13) or (svar1=#27);
end;



procedure visprintdata;

begin
  window(1,1,80,18); textcolor(14); textbackground(1);
  clrscr;
  write('              *** Information og udskrift af data for N Kloder ***');
  gotoxy(5,4); write('Information om data:');
  gotoxy(5,6); write(inf);
end;



procedure printdata;

var  svar1 : char;
     i,fpr : byte;
     tal1 : infstr;

begin
repeat
  svar1:='?';
  visprintdata;

  window(1,19,80,25); textcolor(14); textbackground(2);
  clrscr;
  gotoxy(2,2);  write('<ENTER> Tilbage til hovedmenu');
  gotoxy(2,3);  write('<1>     Start print');
  gotoxy(2,4);  write('<2>     Ny information om data');
  gotoxy(50,6); write('< >...',svar1);
  svar1:=readkey;

  case svar1 of
    '1':
    begin
      window(1,19,80,25); textcolor(14); textbackground(2);
      clrscr;
      fpr:=1;
      (*$I-*) writeln(lst); (*$I+*)
      if IOresult<>0 then
      begin
        fpr:=0;
        gotoxy(5,4); write('Printer er ikke tilsluttet, tast <ENTER>');
        svar:=readkey;
      end;

      if fpr=1 then
      begin
        writeln(lst,'                          *** Data for N Kloder ***');
        writeln(lst); writeln(lst);
        writeln(lst,'  Bibliotek: ',NDF);
        writeln(lst,'  Filnavn: ',NFil);
        writeln(lst,'  ',inf); writeln(lst);  writeln(lst);

        for i:=1 to N do
          writeln(lst,'    (x,y)(',i:2,') = (',xf(.i.):talfelt:taldec,
                               ',',yf(.i.):talfelt:taldec,')');
        writeln(lst);
        for i:=1 to N do
          writeln(lst,'  (vx,vy)(',i:2,') = (',vxf(.i.):talfelt:taldec,
                               ',',vyf(.i.):talfelt:taldec,')');
        writeln(lst);
        for i:=1 to N do
          writeln(lst,'        m(',i:2,') = ',m(.i.):talfelt:taldec);
          writeln(lst);
        for i:=1 to N do
          writeln(lst,'     rmin(',i:2,') = ',rmin(.i.):talfelt:taldec);
        writeln(lst);
        writeln(lst,'            N = ',N:6);
        writeln(lst);
        writeln(lst,'         fmrk = ',fmrk:6);
        writeln(lst,'        fgraf = ',fgraf:6);
        writeln(lst);
        writeln(lst,'       tstart = ',tstart:talfelt:taldec);
        writeln(lst,'        tstop = ',tstop:talfelt:taldec);
        writeln(lst,'           dt = ',dt:talfelt:taldec);
        writeln(lst);
        writeln(lst,'         xmin = ',xmin:talfelt:taldec,
        '         xmax = ',xmax:talfelt:taldec);
        writeln(lst,'         ymin = ',ymin:talfelt:taldec);
        writeln(lst,'          fyx = ',fyx:talfelt:taldec);
        writeln(lst);
        writeln(lst,'      talfelt = ',talfelt:6);
        writeln(lst,'       taldec = ',taldec:6);
        writeln(lst,'        sinke = ',sinke:6);
        writeln(lst);
        writeln(lst,'     xrafmin  = ',xrafmin:talfelt:taldec,
        '     xrafmax  = ',xrafmax:talfelt:taldec);
        writeln(lst,'     vrafmin  = ',vrafmin:talfelt:taldec,
        '     vrafmax  = ',vrafmax:talfelt:taldec);
        writeln(lst,'     mrafmin  = ',mrafmin:talfelt:taldec,
        '     mrafmax  = ',mrafmax:talfelt:taldec);
        writeln(lst,#12);
      end;
    end;

    '2':
    begin
      window(1,19,80,25); textcolor(14); textbackground(2);
      clrscr;
      tal1:=inf;
      gotoxy(27,6); write('(ENTER uden input = skip input)');
      gotoxy(5,3); write('Skriv information om data (max ',strl,' tegn):');
      gotoxy(5,5);
      readln(inf);
      if inf='' then inf:=tal1;
      for i:=1 to strl-length(inf) do inf:=inf+' ';
    end;

    else
  end;
  visprintdata;
until (svar1=#13) or (svar1=#27);
end;




procedure visdatafil;

  const NN = 75;

  var   i : byte;

begin
  window(1,1,80,20); textcolor(14); textbackground(1);
  clrscr;
  writeln('                        *** Datafiler for N kloder ***');
  writeln('Bibliotek: ',NDF);
  writeln(NFil+'  '+inf);
  if pfil=1 then
  begin
    findfirst(NDirFil+'*.*',anyfile,srec);
    findnext(srec); findnext(srec);
  end;
  write('                                                                              ');
  i:=1;
  while (i<=NN) and (doserror=0) do
  begin
    write(srec.name:16);
    findnext(srec);
    i:=i+1;
  end;
  if doserror<>0 then pfil:=0;
  writeln;
end;



procedure datafil;

const  blk1 = #32;
       ct1  = #13;
slet='                                                                     ';
       tekst1 = '(ENTER uden input = exit)';

var    i : byte;
       svar1,blk2,ct2 : char;
       tal1 : infstr;
       DatFil : text;

begin
repeat
  svar1:='?';
  visdatafil;

  window(1,21,80,25); textcolor(14); textbackground(2);
  clrscr;
  gotoxy(2,2);  write('<ENTER> Tilbage til hovedmenu');
  gotoxy(2,3);  write('<1>     Hent datafil');
  gotoxy(2,4);  write('<2>     Gem datafil');
  gotoxy(42,3); write('<3>     Flere datafiler');
  gotoxy(42,4); write('<4>     Nyt bibliotek');
  gotoxy(50,5); write('< >...',svar1);
  svar1:=readkey;

  case svar1 of

    '1': (* Hent datafil *)
    begin
      window(1,21,80,25); textcolor(14); textbackground(2);
      clrscr;
      gotoxy(31,1);  write('*** Hent datafil ***');
      repeat
        gotoxy(35,4); write(tekst1);
        gotoxy(15,3); write(slet);
        gotoxy(15,3); write('Datafils navn : ');
        readln(NFil);
        if NFil<>'' then begin
          assign(DatFil,NDirFil+NFil);
          (*$I-*)
          reset(DatFil);
          read(DatFil,inf,ct2,N,ct2);
          for i:=1 to N do read(DatFil,xf(.i.),blk2,yf(.i.),ct2);
          for i:=1 to N do read(DatFil,vxf(.i.),blk2,vyf(.i.),ct2);
          for i:=1 to N do read(DatFil,m(.i.),ct2);
          for i:=1 to N do read(DatFil,rmin(.i.),ct2);
          read(DatFil,fmrk,blk2,fgraf,ct2,tstart,blk2,tstop,blk2,dt,ct2,
                      xmin,blk2,xmax,blk2,ymin,ct2,fyx,ct2,
                      talfelt,blk2,taldec,blk2,sinke,ct2,
                      xrafmin,blk2,xrafmax,ct2,vrafmin,blk2,
                      vrafmax,ct2,mrafmin,blk2,mrafmax);
          (*$I+*)
        end;
      until (IOresult=0) or (NFil='');
      if NFil<>'' then close(DatFil);
      pfil:=1;
    end;

    '2': (* Gem datafil *)
    begin
      window(1,21,80,25); textcolor(14); textbackground(2);
      clrscr;
      gotoxy(31,1);  write('*** Gem datafil ***');
      gotoxy(35,4); write(tekst1);
      gotoxy(15,3); write(slet);
      gotoxy(15,3); write('Datafils navn : ');
      readln(NFil);
      if NFil<>'' then
      begin
        assign(DatFil,NDirFil+NFil);
        rewrite(DatFil);
        write(DatFil,inf:strl,ct1,N,ct1);
        for i:=1 to N do write(DatFil,xf(.i.),blk1,yf(.i.),ct1);
        for i:=1 to N do write(DatFil,vxf(.i.),blk1,vyf(.i.),ct1);
        for i:=1 to N do write(DatFil,m(.i.),ct1);
        for i:=1 to N do write(DatFil,rmin(.i.),ct1);
        write(DatFil,fmrk,blk1,fgraf,ct1,tstart,blk1,tstop,blk1,dt,ct1,
                     xmin,blk1,xmax,blk1,ymin,ct1,fyx,ct1,
                     talfelt,blk1,taldec,blk1,sinke,ct1,
                     xrafmin,blk1,xrafmax,ct1,vrafmin,blk1,
                     vrafmax,ct1,mrafmin,blk1,mrafmax);
        close(DatFil);
      end;
      pfil:=1;
    end;

    '3': pfil:=pfil+1;

    '4':
    begin
      window(1,21,80,25); textcolor(14); textbackground(2);
      clrscr;
      tal1:=NDF;
      gotoxy(30,4); write('(ENTER uden input = skip input)');
      gotoxy(5,2); write('Bibliotek (max ',strl,' tegn): ');
      readln(NDF);
      if NDF='' then NDF:=tal1;
      NDirFil:=NDF+'\';
      pfil:=1;
    end;

  else  pfil:=1;
  end;
until (svar1=#13) or (svar1=#27);
pfil:=1;
end;



procedure visrafleklode;
begin
  window(1,1,80,18); textcolor(14); textbackground(1);
  clrscr;
  write('                         *** Rafling med N Kloder ***');
  gotoxy(2,3);  write('xrafmin  = ',xrafmin:talfelt:taldec);
  gotoxy(2,4);  write('xrafmax  = ',xrafmax:talfelt:taldec);
  gotoxy(2,6);  write('vrafmin  = ',vrafmin:talfelt:taldec);
  gotoxy(2,7);  write('vrafmax  = ',vrafmax:talfelt:taldec);
  gotoxy(42,3);  write('mrafmin  = ',mrafmin:talfelt:taldec);
  gotoxy(42,4);  write('mrafmax  = ',mrafmax:talfelt:taldec);
  if praf=1 then begin gotoxy(42,12); write('Rafling udfrt'); end;
end;



procedure rafleklode;

var  svar1 : char;
     instr : str12;
     i : byte;
     dxraf,dvraf,dmraf : real;

begin
  praf:=0;
  repeat
    svar1:='?';
    visrafleklode;
    window(1,19,80,25); textcolor(14); textbackground(2);
    clrscr;
    gotoxy(2,2);  write('<ENTER> Tilbage til hovedmenu');
    gotoxy(2,3);  write('<1>     Nye data for xrafmin,xrafmax');
    gotoxy(2,4);  write('<2>     Nye data for vrafmin,vrafmax');
    gotoxy(42,3); write('<3>     Nye data for mrafmin,mrafmax');
    gotoxy(42,4); write('<4>     Udfr rafling');
    gotoxy(42,5); write('               (gamle data slettes!)');
    gotoxy(50,6);  write('< >...',svar1);
    svar1:=readkey;

    case svar1 of

      '1':
      begin
        window(1,19,80,25); textcolor(14); textbackground(2);
        clrscr;
        gotoxy(23,1);  write('*** Data for xrafmin,xrafmax ***');
        indata1('xrafmin',xrafmin);
        indata1('xrafmax',xrafmax);
        visrafleklode;
      end;

      '2':
      begin
        window(1,19,80,25); textcolor(14); textbackground(2);
        clrscr;
        gotoxy(23,1);  write('*** Data for vrafmin,vrafmax ***');
        indata1('vrafmin',vrafmin);
        indata1('vrafmax',vrafmax);
        visrafleklode;
      end;

      '3':
      begin
        window(1,19,80,25); textcolor(14); textbackground(2);
        clrscr;
        gotoxy(23,1);  write('*** Data for mrafmin,mrafmax ***');
        indata1('mrafmin',mrafmin);
        indata1('mrafmax',mrafmax);
        visrafleklode;
      end;


      '4':
      begin
        praf:=1;
        randomize;
        dxraf:=xrafmax-xrafmin;
        dvraf:=vrafmax-vrafmin;
        dmraf:=mrafmax-mrafmin;
        for i:=1 to N do
        begin
          xf(.i.):=xrafmin+dxraf*random;
          yf(.i.):=xrafmin+dxraf*random;
          vxf(.i.):=vrafmin+dvraf*random;
          vyf(.i.):=vrafmin+dvraf*random;
          m(.i.):=mrafmin+dmraf*random;
        end;
        visrafleklode;
      end;

      else
    end;
  until (svar1=#13) or (svar1=#27);
end;




procedure hovedmenu;

  var   svar   : char;
        iii    : byte;

begin
  repeat
    window(1,1,80,25); textcolor(14); textbackground(0);
    clrscr;
    svar:='?';
    gotoxy(10,1);  write('                       *** N Kloder ***');
    gotoxy(5,3);  write('Program til bogen "Planeter", af Kaare Lund Rasmussen og Torsten Meyer,');
    gotoxy(29,4);  write('Munksgaards  Dimensioner');
    gotoxy(1,5); for iii:=1 to 80 do write('-');
    gotoxy(15,7);  write('<ESC>  Forlad programmet');
    gotoxy(15,9);  write('<1>    Simulering');
    gotoxy(15,11);  write('<2>    Data 1: Klode-parametre');
    gotoxy(15,13); write('<3>    Data 2: Antal kloder, flag, KS, m.m.');
    gotoxy(15,15); write('<4>    Information og udskrift af data');
    gotoxy(15,17); write('<5>    Datafiler');
    gotoxy(15,19); write('<6>    Rafle med kloder');
    gotoxy(1,21); for iii:=1 to 80 do write('-');
    gotoxy(2,22);  write('Taster under  <1> Simulering:');
    gotoxy(40,22); write('ENTER    : afbryder');
    gotoxy(40,23); write('MELLEMRUM: pause + tid / fortst');
    gotoxy(2,25);  write('Ls GENEREL.DOC og KLODERN.DOC');
    gotoxy(48,19); write('< >...',svar);
    svar:=readkey;
    clrscr;

    case svar of
      '1': simulering;
      '2': data1;
      '3': data2;
      '4': printdata;
      '5': datafil;
      '6': rafleklode;
      else
    end;

  until svar=#27;
end;



begin (* main *)
  start;
  grafini;
  repeat
    hovedmenu;
    clrscr;
    gotoxy(10,10); write('Vil du forlade programmet? (j/n) ');
    readln(svar);
  until svar in (.'j','J'.);
  clrscr;
end.

