unit KooVin8;  (* Koordinatsystem og vindue    25/1/96 *)


interface

  uses  graph;

  var   gXmax,gYmax : integer;
        gXstart,gYstart,gXslut,gYslut,dXomr,dYomr,fXomr,fYomr : real;
        vXmin,vYmin,vXmax,vYmax,dvX,dvY : integer;

  procedure nymoveto(x,y : real);
  procedure nylineto(x,y : real);
  procedure nyputpixel(x,y : real; farve : word);
  procedure nyouttextxy(x,y : real; text : string);
  procedure nycircle(x,y,r : real);
  procedure nyellipse(x,y:real; stang,endang:word; xrad,yrad:real);
  procedure nyrectangle(x1,y1,x2,y2 : real);
  procedure nygetimage(x1,y1,x2,y2 : real; var bitmap);
  procedure nyputimage(x1,y1 : real; var bitmap; bitblt : word);
  function nyimagesize(x1,y1,x2,y2 : real) : word;
  function sign(x : real) : real;
  function floor(x : real) : real;
  function ceil(x : real) : real;
  function expon(x:real) : real;
  function tiexp(x:real) : real;
  function princ(x:real) : real;
  procedure ks(Xmin,Xmax,Ymin,Ymax : real; talfelt,taldec : shortint);


implementation

  procedure nymoveto(x,y : real);
  begin
    moveto(round((x-gXstart)*fXomr-1),dvY-round((y-gYstart)*fYomr+1));
  end;

  procedure nylineto(x,y : real);
  begin
    lineto(round((x-gXstart)*fXomr-1),dvY-round((y-gYstart)*fYomr+1));
  end;

  procedure nyputpixel(x,y : real; farve : word);
  begin
    putpixel(round((x-gXstart)*fXomr-1),dvY-round((y-gYstart)*fYomr+1),farve);
  end;

  procedure nyouttextxy(x,y : real; text : string);
  begin
    outtextxy(round((x-gXstart)*fXomr-1),dvY-round((y-gYstart)*fYomr+1),text);
  end;

  procedure nycircle(x,y,r : real);
  begin
    circle(round((x-gXstart)*fXomr-1),dvY-round((y-gYstart)*fYomr+1),
                  round(r*fXomr));
  end;

  procedure nyellipse(x,y:real; stang,endang:word; xrad,yrad:real);
  begin
    ellipse(round((x-gXstart)*fXomr-1),dvY-round((y-gYstart)*fYomr+1),
            stang,endang,round(xrad*fXomr),round(yrad*fYomr));
  end;

  procedure nyrectangle(x1,y1,x2,y2 : real);
  begin
    rectangle(round((x1-gXstart)*fXomr-1),dvY-round((y1-gYstart)*fYomr+1),
      round((x2-gXstart)*fXomr-1),dvY-round((y2-gYstart)*fYomr+1));
  end;

  procedure nygetimage(x1,y1,x2,y2 : real;var bitmap);
  begin
    getimage(round((x1-gXstart)*fXomr-1),dvY-round((y1-gYstart)*fYomr+1),
      round((x2-gXstart)*fXomr-1),dvY-round((y2-gYstart)*fYomr+1),bitmap);
  end;

  procedure nyputimage(x1,y1 : real; var bitmap; bitblt : word);
  begin
    putimage(round((x1-gXstart)*fXomr-1),dvY-round((y1-gYstart)*fYomr+1),
             bitmap,bitblt);
  end;

  function nyimagesize(x1,y1,x2,y2 : real) : word;
  begin
    nyimagesize:=
    imagesize(round((x1-gXstart)*fXomr-1),dvY-round((y1-gYstart)*fYomr+1),
             round((x2-gXstart)*fXomr-1),dvY-round((y2-gYstart)*fYomr+1));
  end;

  function sign(x : real) : real;
  begin
    if x<>0 then sign:=abs(x)/x
    else         sign:=0;
  end;

  function floor(x : real) : real;
    var z : real;
  begin
    z:=int(x);
    if (x<0) and (z<>x) then z:=z-1;
    floor:=z;
  end;

  function ceil(x : real) : real;
    var z : real;
  begin
    z:=int(x);
    if (x>0) and (z<>x) then z:=z+1;
    ceil:=z;
  end;

  function rround(x,y:real) : real;
  begin
    rround:=y*floor(x/y+0.5);
  end;

  function expon(x:real) : real;
  begin
   expon:=floor(ln(abs(x))/ln(10));
  end;

  function tiexp(x:real) : real;
  begin
    tiexp:=exp(expon(x)*ln(10));
  end;

  function princ(x:real) : real;
  begin
    princ:=x/tiexp(x);
  end;


  procedure ks(Xmin,Xmax,Ymin,Ymax : real; talfelt,taldec : shortint);

    const  korr=1e-9;

    var    Xpri,Ypri,Xtix,Ytix: real;
           Xtrin,Ytrin,Xdtrin,Ydtrin,X2trin,Y2trin : real;
           NXtrin,NYtrin,Xmark,Ymark,NXdtr,NYdtr : real;
           Xlang,Ylang : real;
           talstreng : string;
           temp : real;


  begin (* ks *)

    if talfelt>10 then
    begin
      talfelt:=10;
      if taldec>7 then taldec:=7;
    end;

    if Xmax<Xmin then begin temp:=Xmin; Xmin:=Xmax; Xmax:=temp; end;
    if Ymax<Ymin then begin temp:=Ymin; Ymin:=Ymax; Ymax:=temp; end;

    if Xmax-Xmin<1e-30 then
    begin Xmin:=0.99*Xmin-0.01; Xmax:=1.01*Xmax+0.01; end;
    if Ymax-Ymin<1e-30 then
    begin Ymin:=0.99*Ymin-0.01; Ymax:=1.01*Ymax+0.01; end;

    dXomr:=Xmax-Xmin; dYomr:=Ymax-Ymin;
    Xtrin:=1; Ytrin:=1;
    NXtrin:=princ(dXomr); NYtrin:=princ(dYomr);
    NXdtr:=5; NYdtr:=5;

    if       NXtrin<=1.2+korr then Xtrin:=Xtrin/10
(*  else if  NXtrin<=2.4+korr then begin Xtrin:=Xtrin/5; NXdtr:=4; end *)
    else if  NXtrin<=3+korr   then Xtrin:=Xtrin/4
    else if  NXtrin<=6+korr   then Xtrin:=Xtrin/2;

    if       NYtrin<=1.2+korr then Ytrin:=Ytrin/10
(*  else if  NYtrin<=2.4+korr then begin Ytrin:=Ytrin/5; NYdtr:=4; end *)
    else if  NYtrin<=3+korr   then Ytrin:=Ytrin/4
    else if  NYtrin<=6+korr   then Ytrin:=Ytrin/2;

    Xtrin:=Xtrin*tiexp(dXomr);
    Ytrin:=Ytrin*tiexp(dYomr);

    Xdtrin:=Xtrin/NXdtr; Ydtrin:=Ytrin/NYdtr;
    X2trin:=Xtrin*2; Y2trin:=Ytrin*2;
    gXstart:=Xmin; gXslut:=Xmax; gYstart:=Ymin; gYslut:=Ymax;


    SetGraphMode(GetGraphMode);  setcolor(14);

    gXmax:=GetMaxX; gYmax:=GetMaxY;
    vXmin:=round(0.15 *gXmax);  vXmax:=round(0.95 *gXmax);
    vYmin:=round(0.083*gYmax);  vYmax:=round(0.917*gYmax);
    dvX  :=vXmax-vXmin;         dvY  :=vYmax-vYmin;
    fXomr:=dvX/dXomr;            fYomr:=dvY/dYomr;
    SetViewport(vXmin+1,vYmin+1,vXmax-1,vYmax-1,ClipOff);

    nymoveto(gXstart,gYstart); nylineto(gXslut,gYstart); nylineto(gXslut,gYslut);
    nylineto(gXstart,gYslut); nylineto(gXstart,gYstart);

    Xmark:=Xdtrin*ceil((gXstart-abs(gXstart)*korr)/Xdtrin);
    while Xmark<=gXslut+abs(gXslut)*korr do
    begin
      Xlang:=rround(Xmark,Xtrin);
      if abs(Xmark-Xlang)>0.1*Xdtrin then
      begin
        nymoveto(Xmark,gYstart-dYomr*0.013); nylineto(Xmark,gYstart);
        nymoveto(Xmark,gYslut+dYomr*0.013); nylineto(Xmark,gYslut);
      end
      else
      begin
        nymoveto(Xmark,gYstart-dYomr*0.026); nylineto(Xmark,gYstart);
        nymoveto(Xmark,gYslut+dYomr*0.026); nylineto(Xmark,gYslut);
      end;
      Xmark:=Xmark+Xdtrin;
    end;

    Ymark:=Ydtrin*ceil((gYstart-abs(gYstart)*korr)/Ydtrin);
    while Ymark<=gYslut+abs(gYslut)*korr do
    begin
      Ylang:=rround(Ymark,Ytrin);
      if abs(Ymark-Ylang)>0.1*Ydtrin then
      begin
        nymoveto(gXstart-dXomr*0.01,Ymark); nylineto(gXstart,Ymark);
        nymoveto(gXslut+dXomr*0.01,Ymark); nylineto(gXslut,Ymark);
      end
      else
      begin
        nymoveto(gXstart-dXomr*0.02,Ymark); nylineto(gXstart,Ymark);
        nymoveto(gXslut+dXomr*0.02,Ymark); nylineto(gXslut,Ymark);
      end;
      Ymark:=Ymark+Ydtrin;
    end;

    Xmark:=X2trin*ceil((gXstart-abs(gXstart)*korr)/X2trin);
    while Xmark<=gXslut+abs(gXslut)*korr do
    begin
      str(Xmark:talfelt:taldec,talstreng);
      if taldec>=0 then nyouttextxy(Xmark-0.015*dXomr*
                        (talfelt-taldec-0.5),gYstart-dYomr/25,talstreng)
      else nyouttextxy(Xmark-0.015*dXomr*(talfelt-3.5),
                         gYstart-dYomr/25,talstreng);
      Xmark:=Xmark+X2trin;
    end;

    Ymark:=Y2trin*ceil((gYstart-abs(gYstart)*korr)/Y2trin);
    while Ymark<=gYslut+abs(gYslut)*korr do
    begin
      str(Ymark:talfelt:taldec,talstreng);
      nyouttextxy(gXstart-0.015*dXomr*(talfelt+2),
                  Ymark+dYomr*0.01,talstreng);
      Ymark:=Ymark+Y2trin;
    end;

    SetViewport(vXmin+1,vYmin+1,vXmax-1,vYmax-1,ClipOn);

  end; (* proc. ks *)


begin
end.
